/**
 * This program forks a separate process using the fork()/exec() system calls.
 *
 * Figure 3.10
 *
 * @author Gagne, Galvin, Silberschatz
 * Operating System Concepts with Java - Eighth Edition
 * Copyright John Wiley & Sons - 2010.
 */

#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>

int main()
{
        pid_t pid;
        int b[10];
        int num = 0, in = 0, out = 0;
        int i;
	int deposited = 0;

        for (i=0; i<10; i++)
	  b[i] = 0;


	/* fork a child process */
	pid = fork();

	if (pid < 0) { /* error occurred */
		fprintf(stderr, "Fork Failed\n");

		return 1;
	}
	else if (pid == 0) { /* child process */
		printf("I am the child/consumer %d\n",pid);
		while (out <= 100)
		  {
		    if (deposited)
		      {
			printf("b = \n");
			for (i=0; i<10; i++)
			  printf("%d ", b[i]);
			printf("\n");
			printf("Child consuming %d\n", b[out % 10]);
			out++;
			num++;
			//deposited = 0;
		      }
		  }
	}
	else { /* parent process */
		/* parent will wait for the child to complete */
		printf("I am the parent/producer %d\n",pid);
                while (num <= 100)
		  {
		    if (!deposited)
		      {
			printf("Parent producing %d\n", in);
		        b[in % 10] = in;
                        in++;
		        num++;
			//deposited = 1;
		      }
		  }
		wait(NULL);
		
		printf("Child Complete\n");
	}

	return 0;
}
