/**
 * Database.java
 *
 * This class contains the methods the readers and writers will use
 * to coordinate access to the database. Access is coordinated using semaphores.
 *
 * Figure 6.18
 *
 * @author Gagne, Galvin, Silberschatz
 * Operating System Concepts with Java - Eighth Edition
 * Copyright John Wiley & Sons - 2010. 
 */

public class Database implements ReadWriteLock
{
    // the number of active readers
    private int readerCount;

    Semaphore rs;  // controls access to readerCount
    Semaphore ws;     // controls access to the database

    public Database() {
        readerCount = 0;

        rs = new Semaphore(1);
        ws = new Semaphore(1);
    }

    public void acquireReadLock(int readerNum) {
        rs.acquire();

        ++readerCount;

        // if I am the first reader tell all others
        // that the database is being read
        if (readerCount == 1)
            ws.acquire();

        System.out.println("Reader " + readerNum + " is reading. Reader count = " + readerCount);
        rs.release();
    }

    public void releaseReadLock(int readerNum) {
        rs.acquire();

        --readerCount;
        System.out.println("Reader " + readerNum + " releasing lock; readerCount = " + readerCount);

        // if I am the last reader tell all others
        // that the database is no longer being read
        if (readerCount == 0)
        {
            System.out.println("\"Last\" reader " + readerNum + " is done reading. Reader count = " + readerCount);
            ws.release();
        }

        rs.release();
    }

    public void acquireWriteLock(int writerNum) {
        ws.acquire();
        System.out.println("writer " + writerNum + " is writing.");
    }

    public void releaseWriteLock(int writerNum) {
        System.out.println("writer " + writerNum + " is done writing.");
        ws.release();
    }

}
